/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour;

import com.cobblemon.mod.common.DoubleJump;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviours;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.client.MountedCameraTypeHandler;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0019\u0010\u001d\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R$\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020%8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R(\u0010,\u001a\u0004\u0018\u00010+2\b\u0010&\u001a\u0004\u0018\u00010+8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/RidingController;", "", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "behaviours", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Ljava/util/Map;)V", "Lnet/minecraft/class_2960;", "behaviour", "", "changeBehaviour", "(Lnet/minecraft/class_2960;)V", "tick", "()V", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "getBehaviour", "()Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lnet/minecraft/class_1309;", "driver", "checkForNewTransition", "(Lnet/minecraft/class_1309;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "", "canTransitionToLand", "()Z", "canTransitionToLiquid", "canTransitionToAir", "(Lnet/minecraft/class_1309;)Z", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Ljava/util/Map;", "getBehaviours", "()Ljava/util/Map;", "", "value", "lastTransitionAge", "I", "getLastTransitionAge", "()I", "Lcom/cobblemon/mod/common/api/riding/behaviour/ActiveRidingContext;", "context", "Lcom/cobblemon/mod/common/api/riding/behaviour/ActiveRidingContext;", "getContext", "()Lcom/cobblemon/mod/common/api/riding/behaviour/ActiveRidingContext;", "common"})
@SourceDebugExtension(value={"SMAP\nRidingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RidingController.kt\ncom/cobblemon/mod/common/api/riding/behaviour/RidingController\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n536#2:158\n521#2,6:159\n1#3:165\n*S KotlinDebug\n*F\n+ 1 RidingController.kt\ncom/cobblemon/mod/common/api/riding/behaviour/RidingController\n*L\n43#1:158\n43#1:159,6\n*E\n"})
public final class RidingController {
    @NotNull
    private final PokemonEntity entity;
    @NotNull
    private final Map<RidingStyle, RidingBehaviourSettings> behaviours;
    private int lastTransitionAge;
    @Nullable
    private ActiveRidingContext context;

    public RidingController(@NotNull PokemonEntity entity, @NotNull Map<RidingStyle, ? extends RidingBehaviourSettings> behaviours) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        this.entity = entity;
        this.behaviours = behaviours;
    }

    @NotNull
    public final PokemonEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final Map<RidingStyle, RidingBehaviourSettings> getBehaviours() {
        return this.behaviours;
    }

    public final int getLastTransitionAge() {
        return this.lastTransitionAge;
    }

    @Nullable
    public final ActiveRidingContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public final void changeBehaviour(@NotNull class_2960 behaviour) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        if (this.entity.getForm().getRiding().getBehaviours() == null) {
            return;
        }
        Map<RidingStyle, RidingBehaviourSettings> map = this.entity.getForm().getRiding().getBehaviours();
        Intrinsics.checkNotNull(map);
        Map<RidingStyle, RidingBehaviourSettings> $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map<RidingStyle, RidingBehaviourSettings> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((RidingBehaviourSettings)it.getValue()).getKey(), (Object)behaviour)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        RidingStyle ridingStyle = (RidingStyle)((Object)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet()));
        if (ridingStyle == null) {
            return;
        }
        RidingStyle style = ridingStyle;
        Map<RidingStyle, RidingBehaviourSettings> map3 = this.entity.getPokemon().getRiding().getBehaviours();
        if (map3 == null || (map3 = map3.get((Object)style)) == null) {
            return;
        }
        Map<RidingStyle, RidingBehaviourSettings> behaviourSettings = map3;
        RidingBehaviourState newState = RidingBehaviours.get(behaviourSettings.getKey()).createDefaultState((RidingBehaviourSettings)((Object)behaviourSettings));
        ActiveRidingContext activeRidingContext = this.context;
        if (activeRidingContext != null) {
            ActiveRidingContext it = activeRidingContext;
            boolean bl = false;
            newState.getStamina().set(it.getState().getStamina().get(), true);
        }
        this.context = new ActiveRidingContext(behaviourSettings.getKey(), (RidingBehaviourSettings)((Object)behaviourSettings), newState, style);
        this.lastTransitionAge = this.entity.getTicksLived();
    }

    public final void tick() {
        if (this.entity.getTicksLived() - this.lastTransitionAge < 10) {
            return;
        }
        RidingStyle newTransition = this.checkForNewTransition(this.entity.method_5642());
        if (newTransition == RidingStyle.AIR) {
            ActiveRidingContext activeRidingContext = this.context;
            if ((activeRidingContext != null ? activeRidingContext.getStyle() : null) != RidingStyle.AIR) {
                ActiveRidingContext activeRidingContext2 = this.context;
                if ((activeRidingContext2 != null ? activeRidingContext2.getState() : null) != null) {
                    ActiveRidingContext activeRidingContext3 = this.context;
                    Intrinsics.checkNotNull((Object)activeRidingContext3);
                    class_243 currVel = activeRidingContext3.getState().getRideVelocity().get();
                    ActiveRidingContext activeRidingContext4 = this.context;
                    Intrinsics.checkNotNull((Object)activeRidingContext4);
                    SidedRidingState.set$default(activeRidingContext4.getState().getRideVelocity(), new class_243(currVel.field_1352, Math.max(0.1, currVel.field_1351), currVel.field_1350), false, 2, null);
                }
            }
        }
        Map<RidingStyle, RidingBehaviourSettings> map = this.entity.getPokemon().getRiding().getBehaviours();
        RidingBehaviourSettings behaviourSettings = map != null ? map.get((Object)newTransition) : null;
        ActiveRidingContext activeRidingContext = this.context;
        if (newTransition != (activeRidingContext != null ? activeRidingContext.getStyle() : null)) {
            if (newTransition != null && behaviourSettings != null) {
                ActiveRidingContext it;
                RidingBehaviourState newState = RidingBehaviours.get(behaviourSettings.getKey()).createDefaultState(behaviourSettings);
                ActiveRidingContext activeRidingContext5 = this.context;
                if (activeRidingContext5 != null) {
                    it = activeRidingContext5;
                    boolean bl = false;
                    newState.getStamina().set(it.getState().getStamina().get(), true);
                }
                ActiveRidingContext activeRidingContext6 = this.context;
                if (activeRidingContext6 != null) {
                    it = activeRidingContext6;
                    boolean bl = false;
                    newState.getRideVelocity().set(it.getState().getRideVelocity().get(), true);
                }
                ActiveRidingContext activeRidingContext7 = this.context;
                class_2960 previousKey = activeRidingContext7 != null ? activeRidingContext7.getBehaviour() : null;
                class_2960 newKey = behaviourSettings.getKey();
                for (class_1297 passenger : this.entity.method_5685()) {
                    if (!(passenger instanceof class_1657) || passenger instanceof class_3222) continue;
                    class_2960 class_29602 = previousKey;
                    if (class_29602 == null) continue;
                    MountedCameraTypeHandler.INSTANCE.handleTransition(passenger, class_29602, newKey);
                }
                this.context = new ActiveRidingContext(behaviourSettings.getKey(), behaviourSettings, newState, newTransition);
                this.lastTransitionAge = this.entity.getTicksLived();
            } else {
                this.context = null;
            }
        }
        if (this.context == null && !this.entity.method_37908().field_9236) {
            this.entity.method_5772();
        }
    }

    @Nullable
    public final RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState> getBehaviour() {
        if (this.context == null) {
            return null;
        }
        ActiveRidingContext activeRidingContext = this.context;
        Intrinsics.checkNotNull((Object)activeRidingContext);
        return RidingBehaviours.get(activeRidingContext.getBehaviour());
    }

    private final RidingStyle checkForNewTransition(class_1309 driver) {
        ActiveRidingContext activeRidingContext = this.context;
        RidingStyle ridingStyle = activeRidingContext != null ? activeRidingContext.getStyle() : null;
        switch (ridingStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ridingStyle.ordinal()]) {
            case 1: {
                if (this.canTransitionToLand()) {
                    return RidingStyle.LAND;
                }
                if (this.canTransitionToLiquid()) {
                    return RidingStyle.LIQUID;
                }
                return RidingStyle.AIR;
            }
            case 2: {
                if (this.canTransitionToAir(driver)) {
                    return RidingStyle.AIR;
                }
                if (this.canTransitionToLand()) {
                    return RidingStyle.LAND;
                }
                return RidingStyle.LIQUID;
            }
            case 3: {
                if (this.canTransitionToAir(driver)) {
                    return RidingStyle.AIR;
                }
                if (this.canTransitionToLiquid()) {
                    return RidingStyle.LIQUID;
                }
                return RidingStyle.LAND;
            }
            case -1: {
                if (this.canTransitionToAir(driver)) {
                    return RidingStyle.AIR;
                }
                if (this.canTransitionToLiquid()) {
                    return RidingStyle.LIQUID;
                }
                if (this.canTransitionToLand()) {
                    return RidingStyle.LAND;
                }
                return null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean canTransitionToLand() {
        if (this.entity.method_5869()) {
            return false;
        }
        if (this.entity.method_5777(class_3486.field_15517) || this.entity.method_5777(class_3486.field_15518)) {
            return false;
        }
        return this.entity.method_24828();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canTransitionToLiquid() {
        Map<RidingStyle, RidingBehaviourSettings> map = this.entity.getPokemon().getRiding().getBehaviours();
        if ((map != null ? map.get((Object)RidingStyle.LIQUID) : null) != null) {
            ActiveRidingContext activeRidingContext = this.context;
            if ((activeRidingContext != null ? activeRidingContext.getStyle() : null) != RidingStyle.AIR) {
                if (this.entity.method_52535()) return true;
                if (!this.entity.method_5869()) return false;
                return true;
            }
        }
        if (this.entity.method_5777(class_3486.field_15517)) return true;
        if (!this.entity.method_5777(class_3486.field_15518)) return false;
        return true;
    }

    private final boolean canTransitionToAir(class_1309 driver) {
        if (driver != null) {
            if (!(driver instanceof DoubleJump)) {
                return false;
            }
            if (this.behaviours.get((Object)RidingStyle.AIR) == null) {
                return false;
            }
            boolean isEyeInLiquid = this.entity.method_5777(class_3486.field_15517) || this.entity.method_5777(class_3486.field_15518);
            ActiveRidingContext activeRidingContext = this.context;
            if ((activeRidingContext != null ? activeRidingContext.getStyle() : null) == RidingStyle.LIQUID && isEyeInLiquid) {
                return false;
            }
            return ((DoubleJump)driver).isDoubleJumping();
        }
        return !this.entity.method_24828() && !this.entity.method_52535() && !this.entity.method_5869();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RidingStyle.values().length];
            try {
                nArray[RidingStyle.AIR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RidingStyle.LIQUID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RidingStyle.LAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

